/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.quickhomes.mixin;

import dev.itsmeow.quickhomes.IStoreHome;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public class ServerPlayerMixin
implements IStoreHome {
    @Unique
    public Vec3 quickhomes_homePos = null;
    @Unique
    public ResourceKey<Level> quickhomes_dimension = null;

    @Inject(at={@At(value="RETURN")}, method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"})
    public void readAdditionalSaveData(CompoundTag tag, CallbackInfo c) {
        CompoundTag data = null;
        if (tag.m_128441_("quickhomes")) {
            data = tag.m_128469_("quickhomes");
        } else if (tag.m_128441_("PlayerPersisted") && tag.m_128469_("PlayerPersisted").m_128441_("quickhomes")) {
            data = tag.m_128469_("PlayerPersisted").m_128469_("quickhomes");
        }
        if (data != null && data.m_128441_("x") && data.m_128441_("y") && data.m_128441_("z") && data.m_128441_("dim")) {
            this.quickhomes_homePos = new Vec3(data.m_128459_("x"), data.m_128459_("y"), data.m_128459_("z"));
            this.quickhomes_dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(data.m_128461_("dim")));
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"})
    public void addAdditionalSaveData(CompoundTag tag, CallbackInfo c) {
        if (this.quickhomes_homePos != null && this.quickhomes_dimension != null) {
            CompoundTag data = new CompoundTag();
            data.m_128347_("x", this.quickhomes_homePos.m_7096_());
            data.m_128347_("y", this.quickhomes_homePos.m_7098_());
            data.m_128347_("z", this.quickhomes_homePos.m_7094_());
            data.m_128359_("dim", this.quickhomes_dimension.m_135782_().toString());
            tag.m_128365_("quickhomes", (Tag)data);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"restoreFrom(Lnet/minecraft/server/level/ServerPlayer;Z)V"})
    public void restoreFrom(ServerPlayer serverPlayer, boolean bl, CallbackInfo c) {
        ServerPlayerMixin serverPlayerMixin = (ServerPlayerMixin)serverPlayer;
        this.quickhomes_homePos = serverPlayerMixin.quickhomes_homePos;
        this.quickhomes_dimension = serverPlayerMixin.quickhomes_dimension;
    }

    @Override
    public void setHome(Vec3 pos, ResourceKey<Level> dimension) {
        this.quickhomes_homePos = pos;
        this.quickhomes_dimension = dimension;
    }

    @Override
    public Pair<Vec3, ResourceKey<Level>> getHome() {
        return Pair.of((Object)this.quickhomes_homePos, this.quickhomes_dimension);
    }
}

